/*
 * Decompiled with CFR 0.152.
 */
package jssc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import jssc.SerialNativeInterface;
import jssc.SerialPort;
import jssc.SerialPortException;

public class SerialPortList {
    private static SerialNativeInterface serialInterface;
    private static Comparator<String> comparator;

    public static String[] getPortNames() {
        if (SerialNativeInterface.getOsType() == 0) {
            return SerialPortList.getLinuxPortNames();
        }
        if (SerialNativeInterface.getOsType() == 2) {
            return SerialPortList.getSolarisPortNames();
        }
        if (SerialNativeInterface.getOsType() == 3) {
            return SerialPortList.getMacOSXPortNames();
        }
        String[] portNames = serialInterface.getSerialPortNames();
        if (portNames == null) {
            return new String[0];
        }
        TreeSet<String> ports = new TreeSet<String>(comparator);
        ports.addAll(Arrays.asList(portNames));
        return ports.toArray(new String[ports.size()]);
    }

    private static String[] getLinuxPortNames() {
        String[] returnArray = new String[]{};
        try {
            Process dmesgProcess = Runtime.getRuntime().exec("dmesg");
            BufferedReader reader = new BufferedReader(new InputStreamReader(dmesgProcess.getInputStream()));
            TreeSet<String> portsTree = new TreeSet<String>();
            ArrayList<String> portsList = new ArrayList<String>();
            String buffer = "";
            while ((buffer = reader.readLine()) != null && !buffer.isEmpty()) {
                String[] tmp;
                if (!buffer.matches(".*(ttyS|ttyUSB)[0-9]{1,3}.*")) continue;
                for (String value : tmp = buffer.split(" ")) {
                    if (!value.matches("(ttyS|ttyUSB)[0-9]{1,3}")) continue;
                    portsTree.add("/dev/" + value);
                }
            }
            for (String portName : portsTree) {
                SerialPort serialPort = new SerialPort(portName);
                try {
                    if (!serialPort.openPort()) continue;
                    portsList.add(portName);
                    serialPort.closePort();
                }
                catch (SerialPortException ex) {
                    if (!ex.getExceptionType().equals("Port busy")) continue;
                    portsList.add(portName);
                }
            }
            returnArray = portsList.toArray(returnArray);
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return returnArray;
    }

    private static String[] getSolarisPortNames() {
        File[] files;
        String[] returnArray = new String[]{};
        File dir = new File("/dev/term");
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()).length > 0) {
            TreeSet<String> portsTree = new TreeSet<String>();
            ArrayList<String> portsList = new ArrayList<String>();
            for (File file : files) {
                if (file.isDirectory() || file.isFile() || !file.getName().matches("[0-9]*|[a-z]*")) continue;
                portsTree.add("/dev/term/" + file.getName());
            }
            for (String portName : portsTree) {
                portsList.add(portName);
            }
            returnArray = portsList.toArray(returnArray);
        }
        return returnArray;
    }

    private static String[] getMacOSXPortNames() {
        File[] files;
        String[] returnArray = new String[]{};
        File dir = new File("/dev");
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()).length > 0) {
            TreeSet<String> portsTree = new TreeSet<String>();
            ArrayList<String> portsList = new ArrayList<String>();
            for (File file : files) {
                if (file.isDirectory() || file.isFile() || !file.getName().matches("tty.(serial.*|usbserial.*)")) continue;
                portsTree.add("/dev/" + file.getName());
            }
            for (String portName : portsTree) {
                portsList.add(portName);
            }
            returnArray = portsList.toArray(returnArray);
        }
        return returnArray;
    }

    static {
        comparator = new Comparator<String>(){

            @Override
            public int compare(String valueA, String valueB) {
                int result = 0;
                if (valueA.toLowerCase().contains("com") && valueB.toLowerCase().contains("com")) {
                    try {
                        int index1 = Integer.valueOf(valueA.toLowerCase().replace("com", ""));
                        int index2 = Integer.valueOf(valueB.toLowerCase().replace("com", ""));
                        result = index1 - index2;
                    }
                    catch (Exception ex) {
                        result = valueA.compareToIgnoreCase(valueB);
                    }
                } else {
                    result = valueA.compareToIgnoreCase(valueB);
                }
                return result;
            }
        };
        serialInterface = new SerialNativeInterface();
    }
}

