/*
 * Decompiled with CFR 0.152.
 */
package org.mantlik.rs232dump;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class Rs232MainDialog
extends JFrame
implements SerialPortEventListener,
HyperlinkListener {
    private static final DateFormat DF = new SimpleDateFormat("yyyyMMdd_HHmm");
    boolean dumpRunning;
    long bytes;
    long lines;
    SerialPort serialPort;
    OutputStream outputStream = null;
    ArrayList<String> receivedLines = new ArrayList();
    String currLine = "";
    private JComboBox baudrateItem;
    private JComboBox bitsItem;
    private JButton browseItem;
    private JTextPane creditsPane;
    private JTextField fileNameItem;
    private JComboBox flowControlItem;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JComboBox parityItem;
    private JComboBox portItem;
    private JButton proceedItem;
    private JLabel receivedBytesItem;
    private JLabel receivedLinesItem;
    private JTextArea showDataItem;
    private JComboBox stopBitsItem;

    public Rs232MainDialog() {
        this.initComponents();
        String[] portNames = SerialPortList.getPortNames();
        this.portItem.removeAllItems();
        for (int i = 0; i < portNames.length; ++i) {
            this.portItem.addItem(portNames[i]);
        }
        ArrayList<Image> iconList = new ArrayList<Image>();
        iconList.add(Toolkit.getDefaultToolkit().getImage(Rs232MainDialog.class.getResource("icon16.png")));
        iconList.add(Toolkit.getDefaultToolkit().getImage(Rs232MainDialog.class.getResource("icon48.png")));
        this.setIconImages(iconList);
        this.creditsPane.addHyperlinkListener(this);
    }

    private void initComponents() {
        this.proceedItem = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.parityItem = new JComboBox();
        this.baudrateItem = new JComboBox();
        this.jLabel7 = new JLabel();
        this.browseItem = new JButton();
        this.portItem = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.flowControlItem = new JComboBox();
        this.jLabel3 = new JLabel();
        this.bitsItem = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel2 = new JLabel();
        this.fileNameItem = new JTextField();
        this.stopBitsItem = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.showDataItem = new JTextArea();
        this.receivedLinesItem = new JLabel();
        this.receivedBytesItem = new JLabel();
        this.creditsPane = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("BlueWhale RS-232 dump");
        this.proceedItem.setText("Start dump");
        this.proceedItem.setToolTipText("");
        this.proceedItem.setEnabled(false);
        this.proceedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rs232MainDialog.this.proceedItemActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Transfer settings", 0, 0, null, new Color(51, 153, 255)));
        this.jLabel5.setText("Flow control:");
        this.parityItem.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Odd", "Even", "Mark"}));
        this.baudrateItem.setModel(new DefaultComboBoxModel<String>(new String[]{"300", "600", "1200", "4800", "9600", "14400", "19200", "38400", "57600", "115200", "128000", "256000"}));
        this.baudrateItem.setSelectedIndex(2);
        this.jLabel7.setText("Parity:");
        this.browseItem.setText("Browse...");
        this.browseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rs232MainDialog.this.browseItemActionPerformed(evt);
            }
        });
        this.portItem.setModel(new DefaultComboBoxModel<String>(new String[]{"COM1", "COM2"}));
        this.jLabel4.setText("Stop bits:");
        this.jLabel1.setText("Port:");
        this.flowControlItem.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Xon/Xoff", "Hardware"}));
        this.jLabel3.setText("Data bits:");
        this.bitsItem.setModel(new DefaultComboBoxModel<String>(new String[]{"7", "8"}));
        this.jLabel6.setText("Save as:");
        this.jLabel2.setText("Baudrade:");
        this.fileNameItem.setEditable(false);
        this.stopBitsItem.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2"}));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.portItem, 0, -1, Short.MAX_VALUE).addComponent(this.baudrateItem, 0, -1, Short.MAX_VALUE).addComponent(this.bitsItem, 0, -1, Short.MAX_VALUE).addComponent(this.stopBitsItem, 0, -1, Short.MAX_VALUE).addComponent(this.flowControlItem, 0, -1, Short.MAX_VALUE).addComponent(this.parityItem, -2, 173, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.fileNameItem, -2, 312, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.browseItem))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portItem, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.baudrateItem, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bitsItem, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stopBitsItem, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.parityItem, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.flowControlItem, -2, -1, -2).addComponent(this.jLabel5)).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameItem, -2, -1, -2).addComponent(this.browseItem)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Transfer progress", 0, 0, null, new Color(51, 153, 255)));
        this.showDataItem.setColumns(20);
        this.showDataItem.setEditable(false);
        this.showDataItem.setRows(8);
        this.jScrollPane1.setViewportView(this.showDataItem);
        this.receivedLinesItem.setHorizontalAlignment(11);
        this.receivedLinesItem.setText("0  lines received");
        this.receivedBytesItem.setHorizontalAlignment(11);
        this.receivedBytesItem.setText("0 bytes received");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.receivedBytesItem, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.receivedLinesItem, -2, 146, -2).addGap(17, 17, 17)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane1).addContainerGap()))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.receivedBytesItem).addComponent(this.receivedLinesItem)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.creditsPane.setBorder(null);
        this.creditsPane.setContentType("text/html");
        this.creditsPane.setEditable(false);
        this.creditsPane.setText("<html>\r   <head>\r \r   </head>\r   <body>\r     <p align=\"center\" style=\"margin-top: 0\">\r <a href=\"http://bluewhaleprocessing.com\">Visit BlueWhaleProcessing.com</a></p>\r   </body>\r</html>\r");
        this.creditsPane.setAutoscrolls(false);
        this.creditsPane.setCursor(new Cursor(0));
        this.creditsPane.setMargin(new Insets(0, 0, 0, 0));
        this.creditsPane.setMinimumSize(new Dimension(10, 10));
        this.creditsPane.setName("");
        this.creditsPane.setOpaque(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proceedItem, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.creditsPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proceedItem).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.creditsPane, -2, 22, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.pack();
    }

    private void browseItemActionPerformed(ActionEvent evt) {
        FileDialog dial = new FileDialog((Frame)this, "Save dumped data", 1);
        dial.setSize(dial.getSize());
        dial.setLocationRelativeTo(null);
        String file = this.fileNameItem.getText();
        dial.setFile(file);
        dial.setVisible(true);
        if (dial.getFile() != null) {
            this.fileNameItem.setText(dial.getDirectory() + dial.getFile());
            this.proceedItem.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedItemActionPerformed(ActionEvent evt) {
        if (!this.dumpRunning) {
            try {
                Rs232MainDialog rs232MainDialog = this;
                synchronized (rs232MainDialog) {
                    this.proceedItem.setText("Stop");
                    this.dumpRunning = true;
                }
                this.bytes = 0L;
                this.lines = 0L;
                this.receivedBytesItem.setText(this.bytes + " bytes received");
                this.receivedLinesItem.setText(this.lines + "  lines received");
                this.showDataItem.setText("Waiting for data...");
                this.receivedLines.clear();
                this.currLine = "";
                String port = (String)this.portItem.getSelectedItem();
                int baudrate = Integer.parseInt((String)this.baudrateItem.getSelectedItem());
                int dataBits = Integer.parseInt((String)this.bitsItem.getSelectedItem());
                int stopBits = Integer.parseInt((String)this.stopBitsItem.getSelectedItem());
                int parity = this.parityItem.getSelectedIndex();
                int flowControl = this.flowControlItem.getSelectedIndex();
                String file = this.fileNameItem.getText();
                this.serialPort = new SerialPort(port);
                this.serialPort.openPort();
                this.serialPort.setParams(baudrate, dataBits, stopBits, parity);
                if (flowControl == 0) {
                    this.serialPort.setFlowControlMode(0);
                } else if (flowControl == 1) {
                    this.serialPort.setFlowControlMode(12);
                } else {
                    this.serialPort.setFlowControlMode(3);
                }
                this.serialPort.setEventsMask(1);
                this.outputStream = new BufferedOutputStream(new FileOutputStream(file));
                this.serialPort.addEventListener(this);
            }
            catch (Exception ex) {
                Logger.getLogger(Rs232MainDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                Rs232MainDialog ex = this;
                synchronized (ex) {
                    this.dumpRunning = false;
                    this.proceedItem.setText("Start dump");
                }
                this.serialPort.removeEventListener();
                this.serialPort.closePort();
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                this.proceedItem.setEnabled(false);
            }
            catch (Exception ex) {
                Logger.getLogger(Rs232MainDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rs232MainDialog dialog = new Rs232MainDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setSize(dialog.getSize());
                dialog.setLocationRelativeTo(null);
                dialog.fileNameItem.setText(DF.format(new Date(System.currentTimeMillis())) + ".txt");
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void serialEvent(SerialPortEvent serialPortEvent) {
        if (serialPortEvent.isRXCHAR()) {
            byte[] b = null;
            try {
                b = this.serialPort.readBytes();
            }
            catch (SerialPortException ex) {
                Logger.getLogger(Rs232MainDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (b != null) {
                for (int i = 0; i < b.length; ++i) {
                    byte bb = b[i];
                    if (bb == 0) continue;
                    ++this.bytes;
                    if (bb != 13 && bb != 10) {
                        this.currLine = this.currLine + (char)bb;
                    }
                    if (bb == 10) {
                        this.receivedLines.add(this.currLine);
                        this.currLine = "";
                        while (this.receivedLines.size() > this.showDataItem.getRows()) {
                            this.receivedLines.remove(0);
                        }
                        String text = "";
                        for (int j = 0; j < this.receivedLines.size(); ++j) {
                            text = text + this.receivedLines.get(j);
                            if (j >= this.receivedLines.size() - 1) continue;
                            text = text + "\n";
                        }
                        this.showDataItem.setText(text);
                        ++this.lines;
                    }
                    try {
                        this.outputStream.write(bb);
                        continue;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Rs232MainDialog.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            this.receivedBytesItem.setText(this.bytes + " bytes received");
            this.receivedLinesItem.setText(this.lines + "  lines received");
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                Desktop.getDesktop().browse(e.getURL().toURI());
            }
            catch (IOException ex) {
                Logger.getLogger(Rs232MainDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(Rs232MainDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

